/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.urgentpath;

import com.google.common.collect.ImmutableList;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class Production
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final GeneralizedOrderRequest gor;
    private final GeneralizedActionRequest gar;
    private final String capability;
    private final String capabilityDesc;
    private final ImmutableList<Workplace> workplaces;
    private final long resourceRequirement;
    private final long logisticTime;
    private final long start;
    private final long end;
    private final long length;

    public Production(GeneralizedOrderRequest gor, GeneralizedActionRequest gar, String capability, String capabilityDesc, List<Workplace> workplaces, long resourceRequirement, long logisticTime, long start, long end, long length) {
        this.gor = gor;
        this.gar = gar;
        this.capability = capability;
        this.capabilityDesc = capabilityDesc;
        this.workplaces = ImmutableList.copyOf(workplaces);
        this.resourceRequirement = resourceRequirement;
        this.logisticTime = logisticTime;
        this.start = start;
        this.end = end;
        this.length = length;
    }

    public GeneralizedOrderRequest getGor() {
        return this.gor;
    }

    public GeneralizedActionRequest getGar() {
        return this.gar;
    }

    public String getCapability() {
        return this.capability;
    }

    public String getCapabilityDesc() {
        return this.capabilityDesc;
    }

    public ImmutableList<Workplace> getWorkplaces() {
        return this.workplaces;
    }

    public long getResourceRequirement() {
        return this.resourceRequirement;
    }

    public long getLogisticTime() {
        return this.logisticTime;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getLength() {
        return this.length;
    }

    public String toString() {
        return "Production{gor=" + this.gor.getId() + ", gar=" + this.gar.getAction() + ", capability='" + this.capability + "', resourceRequirement=" + (double)this.resourceRequirement / 1000.0 / 3600.0 + " h, logisticTime=" + (double)this.logisticTime / 1000.0 / 3600.0 + " h, start=" + new Date(this.start) + ", end=" + new Date(this.end) + ", length=" + (double)this.length / 1000.0 / 3600.0 + " h}";
    }
}

